//=============================================================================
//
// Q[ [modeGame.cpp]
// Author : KENSUKE WATANABE
//
//=============================================================================
#include "main.h"
#include <vector>
#include "manager.h"
#include "modeTitle.h"
#include "modeGame.h"
#include "modeResult.h"
#include "inputKeyboard.h"
#include "scene.h"
#include "scene2D.h"
#include "scene3D.h"
#include "sceneModel.h"
#include "sceneField.h"
#include "sceneSkyDome.h"
#include "sceneCylinder.h"
#include "bgCylinder.h"
#include "effect3DPoly.h"
#include "player.h"
#include "enemy.h"
#include "gravityObj.h"
#include "utility.h"
#include "camera.h"
#include "bar.h"
#include "car.h"
#include "Wwise.h"

// ======== ======== ======== ======== ======== ======== ======== ========
// FilePass̒萔`
// -------- -------- -------- -------- -------- -------- -------- --------
static const char* TEXNAME_POLYGON = "data/TEXTURE/kobeni0.png";
static const char* POLYGON_TEXTURENAME = "data/TEXTURE/wara.jpg";
static const char* TEXNAME_FIELD = "data/TEXTURE/kusa.jpg";
static const char* TEXNAME_SKYDOME = "data/TEXTURE/sky000.jpg";
static const char* TEXNAME_CYLINDERMOUNTAIN = "data/TEXTURE/mountain000.png";
static const char* MODELNAME_CAR_BODY = "data/MODEL/car/body.x";
static const char* MODELNAME_BLACKSHEEP_BODY = "data/MODEL/blackSheep/00_Body.x";
static const char* MODELNAME_KI = "data/MODEL/MD/ki.x";
static const char* MODELNAME_KOYA = "data/MODEL/MD/koya.x";
static const char* TEXNAME_BGCYLINDER = "data/TEXTURE/BG/WtoB.png";
// UI
static const char* GAMEUI_TEXNAME_HP = "data/TEXTURE/GameUI/hp.png";

// ======== ======== ======== ======== ======== ======== ======== ========
// ÓIoϐ̐錾Ə
// -------- -------- -------- -------- -------- -------- -------- --------
// CScore *CModeGame::m_pScore = nullptr;

//=============================================================================
// 
//=============================================================================
void CModeGame::Init(void)
{
	CCamera *pCam = CManager::GetCamera();
	pCam->Init();
	pCam->SetatObjType(pCam->AT_OBJTYPE::CONTROL_PLAYER);

	// IuWFNg
	Create();

	// BGMĐ
	CWwise *pWwise = CManager::GetWwise();
	pWwise->CreateNoListenerGameObj(D3DXVECTOR3(0.f, 0.f, 0.f), D3DXVECTOR3(0.f, 0.f, 0.f), "BGM_YURUMU2");
	pWwise->SetEvent(EVENTS::BGM_YURUMU2, "BGM_YURUMU2");
}

//=============================================================================
// 
//=============================================================================
void CModeGame::Create(void)
{
	// XJCh[
	CSceneSkydome *pSceneSkydome = nullptr;
	pSceneSkydome->Create(D3DXVECTOR3(0.f, -500.f, 0.f), D3DXVECTOR3(0.f, 0.f, 0.f), D3DXVECTOR3(1000.f, 1500.f, 1000.f), TEXNAME_SKYDOME);

	// bVtB[h
	CSceneField *pSceneField = nullptr;
	m_pField = pSceneField->Create(D3DXVECTOR3(0.f, 0.f, 0.f), D3DXVECTOR3(0.f, 0.f, 0.f), D3DXVECTOR3(1000.f, 1.f, 1000.f), TEXNAME_FIELD);

	// vC[
	m_pPlayer = nullptr;
	m_pPlayer = m_pPlayer->Create(D3DXVECTOR3(0.f, 1.f, 0.f), D3DXVECTOR3(0.f, 0.f, 0.f), MODELNAME_CAR_BODY);
}

//=============================================================================
// I
//=============================================================================
void CModeGame::Uninit(void)
{
	// o[̑S
	CBar2D::ReleaseAll();

	// Ԃ̉
	CCar::ReleaseAll();

	// V[S
	CScene::ReleaseAll();

	// GtFNgp3D|SSZbg
	CEffect3DPoly::FlashAll();

	// J_^Cv̕ύX
	CCamera *pCam = CManager::GetCamera();
	pCam->Init();
	pCam->SetatObjType(pCam->AT_OBJTYPE::NONE);

	// Đ~
	CManager::GetWwise()->Stop("BGM_YURUMU2");
}

//=============================================================================
// XV
//=============================================================================
void CModeGame::Update(void)
{
	CInputKeyboard keyboard = CManager::GetKeyboard();

	m_pPlayer->Update();

	// ĐʒuXV
	CManager::GetWwise()->SetPos("BGM_YURUMU2", D3DXVECTOR3(0.f, 0.f, 0.f));

	// o[̑SXV
	CBar2D::UpdateAll();

	// ʑJ
	if (keyboard.GetTrigger(DIK_RETURN))
	{
		CManager::SetMode(new CModeResult);
	}
}

//=============================================================================
// `揈
//=============================================================================
void CModeGame::Draw(void)
{

}